#!/usr/bin/env python

from apns import APNs
import sys
import psycopg2
import datetime
from psycopg2.extensions import adapt


def date():
    return str(datetime.datetime.now()) + " "

def store(cursor, pairs, cert_file):
    try:
        tokens = "ARRAY[" + ",".join(adapt(str(tup[0])).getquoted() for tup in pairs) + "]"
        timestamps = "ARRAY[" + ",".join(adapt(str(tup[1])).getquoted() + "::timestamp" for tup in pairs) + "]"
        sql = "select code.add_broken_subscriptions('ios', " + tokens + ", " + timestamps + " + ", 'off'");"
        cursor.execute( sql )
        rows = cursor.fetchall()
        ts = date()
        for pair in pairs:
            sys.stdout.write(ts + str(pair[0]) + " " + str(pair[1]) + "\n")
    except BaseException,e:
        sys.stderr.write(date() + cert_file + " exception: " + str(e) + "\n")

if len(sys.argv) != 3:
    print "usage:\n\tget_apns_feedback.py <conninfo> <cert_file>"
    sys.exit(1)

try:
    conninfo = sys.argv[1]
    cert_file = sys.argv[2]

    STORE_STEP = 100

    connection = psycopg2.connect(conninfo)
    connection.set_isolation_level(0)
    cursor = connection.cursor()

    feedback_connection = APNs(use_sandbox=False, cert_file=cert_file)
    pairs = []
    for (token_hex, fail_time) in feedback_connection.feedback_server.items():
        pairs.append((token_hex, fail_time))
        if len(pairs) % STORE_STEP == 0:
            store(cursor, pairs, cert_file)
            pairs = []

    if len(pairs):
        store(cursor, pairs, cert_file)

    connection.close()
except BaseException,e:
    sys.stderr.write(date() + cert_file + " exception: " + str(e) + "\n")
    sys.exit(2)

sys.exit(0)
