#!/bin/bash

set -e
set -o pipefail

CONN="host=pgproxy.mail.yandex.net user=xiva dbname=xivadb port=6432"
#CONN="host=pgproxy-test.mail.yandex.net port=6432 dbname=xivadb user=xiva"
#CONN="host=pgproxy-test.mail.yandex.net port=6432 dbname=xivadb_dev user=xiva_dev password=x3fzQJwKvFLmlqnCV7nhhskng"

HUB=xivahub.mail.yandex.net
#HUB=xivahub-tst02e.mail.yandex.net


date >> select.log
date >> curl.log
psql -tA "${CONN}" -f request -F $'\t' 1> select.data 2>>select.log

cat select.data |sort | uniq | awk '{print $1,$2,$3,$5,$6}' | sort -r -k3,4 > sorted.data
cat sorted.data | awk '{ if (id == $3) {print}  id = $3 }' > reduced.data

shuf reduced.data \
  | awk '{ print "/unsubscribe?uid="$1"&service="$2"&subscription-id="$3 }' \
  | while read line; do \
      echo "${HUB}${line}"; \
    done > urls.txt
cat urls.txt \
  | xargs -L 1 -I _ -- bash -c "curl -s '_' >>curl.log; sleep 0.05"
