#!/usr/bin/env bash

test -z ${1} || test -z ${2} && { echo "Usage: ${0} hash1 hash2" ; exit 1; }

REF1=${1}
REF2=${2}
GIT_LOG="git --no-pager log --color --oneline --abbrev-commit --name-status --graph --decorate"

${GIT_LOG} ${REF1}..${REF2}

submodules=($(git submodule status | awk '{print $2}'))

for mod in "${submodules[@]}"
do
  mod_rev1=$(git ls-tree ${REF1} ${mod} | awk '{print $3}')
  mod_rev2=$(git ls-tree ${REF2} ${mod} | awk '{print $3}')
  mod_diff=$(cd ${mod} && ${GIT_LOG} ${mod_rev1}..${mod_rev2})
  if [ ! -z "${mod_diff// }" ]
  then
    echo "submodule ${mod} diff:" && echo "${mod_diff}" && echo & echo
  fi
done
