#!/usr/bin/env python2
import sys, getopt, urllib, urllib2, math, json, time

def check_ping(url):
    return urllib2.urlopen(url + "/ping").read() == "pong"

opts,args = getopt.getopt(sys.argv[1:], "", ["hub=", "reaper=", "reaper_url=", "service=", "count="])

hub=""
reaper=""
reaper_url=""
service=""
count=0

for opt,arg in opts:
    if opt == "--hub":
        if not check_ping(arg):
            print "no answer from hub"
            sys.exit(1)
        hub = arg
    if opt == "--reaper":
        if not check_ping(arg):
            print "no answer from reaper"
            sys.exit(1)
        reaper = arg
    if opt == "--service":
        service = arg
    if opt == "--count":
        count = int(arg)
    if opt == "--reaper_url":
        reaper_url = arg

if hub == "": print "please specify hub URL"; sys.exit(1)
if reaper == "": print "please specify reaper URL"; sys.exit(1)
if reaper_url == "": print "please specify reaper URL (try /passport_hook)"; sys.exit(1)
if service == "": print "please specify service"; sys.exit(1)
if count == 0: print "please specify users count"; sys.exit(1)

def gen_subscribe_url(url, uid, callback):
    uri = url + "/subscribe?uid=stream_" + str(uid) + "&service=" + service + "&callback=" + urllib.quote(callback) + "&ttl=31536000"
    return uri

subscribe_urls = []
for uid in range(0, count):
    callback = reaper + reaper_url
    subscribe_urls.append(gen_subscribe_url(hub, uid, callback))

for url in subscribe_urls:
   print url
