#!/usr/bin/env python

import json
import sys
from copy import deepcopy

def sync(dump, root, key, subkeys, master, slaves):
    for node in dump[root]:
        if node[key] == master[key]:
            master_dump = node
            break

    for i, node in enumerate(dump[root]):
        for slave in slaves:
            if node[key] == slave[key]:
                node_name = node[key]
                dump[root][i] = deepcopy(master_dump)
                dump[root][i][key] = node_name
                for subkey in subkeys:
                    if dump[root][i][subkey]:
                        dump[root][i][subkey] = slave[subkey]
                break
    return dump

def main():
    dump = json.loads(sys.stdin.read())
    master = {'location':'/shards/1/', 'componentName':"hub-shard1"}
    slaves = [{'location':'/shards/{}/'.format(i),
        'upstreamPath':'/shards/{}/'.format(i),
        'componentName':'hub-shard{}'.format(i)} for i in range(2, 32 + 1)]
    dump = sync(dump, 'routeSettings', 'location', ['componentName','upstreamPath'], master, slaves)
    dump = sync(dump, 'components', 'componentName', [], master, slaves)
    print json.dumps(dump, indent=4, sort_keys=True)

if __name__ == '__main__':
    main()
