#!/usr/bin/python

import os
import sys
import json
import re
import argparse
import errno

def checkpoint_type(r):
    m = re.match('^checkpoint (\S+):', r['message']['message'])
    return m.group(1) if m is not None else None

def checkpoints(r):
    if r is None:
        return
    c_type = checkpoint_type(r)
    if c_type is None:
        return
    print('{} | {}'.format(c_type, r['timestamp']))

def tskv(r):
    if not r is None:
        message_kv = r['message']
        print('{}\t{}\t{}'.format(r['timestamp'], message_kv['hostname'],
            message_kv['text'] if 'text' in message_kv else message_kv['message']))

def main():
    parser = argparse.ArgumentParser(description='Apply some operations to pgaas log file records.')
    parser.add_argument('log_file_path', help='path to pgaas log')
    parser.add_argument('--checkpoints', action='store_true', help='print start and end of each checkpoint')
    parser.add_argument('--tskv', action='store_true', help='print log_time <TAB> message')
    args = parser.parse_args()

    ops = []
    if args.checkpoints:
        ops.append(checkpoints)
    if args.tskv:
        ops.append(tskv)

    with open(args.log_file_path) as log_file:
        try:
            log_recs = json.load(log_file)

            for r in log_recs:
                for op in ops:
                    op(r)

            # Notify operation that all records were read
            for op in ops:
                op(None)
        except IOError as e:
            if e.errno == errno.EPIPE:
                # Probably piping output to somebody and he closed his end.
                pass
            else:
                raise

if __name__ == '__main__':
    main()