#!/usr/bin/env python2
import sys, getopt, urllib, urllib2, math, json, time

FAKE_UID=0

def check_ping(url):
    return urllib2.urlopen("http://" + url + "/ping").read() == "pong"

def gen_unsubscribe_all_urls(url,service):
    list_url = "http://" + url + "/list_json?uid=&service="+service
    print "list url:", list_url
    list = json.loads(urllib2.urlopen(list_url).read())
    result = []
    for s in list:
        print "in list:", s["id"], s["url"]
        result.append("http://" + url + "/unsubscribe?uid=&service="+service+"&subscription-id=" + s["id"])
    return result

def gen_subscribe_url(url, callback):
    uri = "http://" + url + "/subscribe?uid=&service=" + service + "&callback=" + urllib.quote(callback) + "&ttl=31536000"
    return uri
    # return urllib2.urlopen(uri).read()

opts,args = getopt.getopt(sys.argv[1:], "", ["hub=", "mesh=", "service=", "users="])

hub=""
mesh=""
service=""
users=0

for opt,arg in opts:
    if opt == "--hub":
        if not check_ping(arg):
            print "no answer from hub"
            sys.exit(1)
        hub = arg
    if opt == "--mesh":
        if not check_ping(arg):
            print "no answer from mesh"
            sys.exit(1)
        mesh = arg
    if opt == "--service":
        service = arg
    if opt == "--users":
        users = int(arg)

if hub == "": print "please specify hub URL"; sys.exit(1)
if mesh == "": print "please specify mesh URL"; sys.exit(1)
if service == "": print "please specify service"; sys.exit(1)
if users == 0: print "please specify users count"; sys.exit(1)

min_count = 4
count = max(min_count, int(math.ceil(users/10000.0)) % 65536)
step = 65536 / count

unsubscribe_urls = gen_unsubscribe_all_urls(hub, service)
subscribe_urls = []
for i in range(0, count):
    gid_from = i*step
    gid_to = (i+1)*step-1
    if i == count-1:
        gid_to = 65535
    callback = "http://" + mesh + "/send?gid_from=" + str(gid_from) + "&gid_to=" + str(gid_to)
    subscribe_urls.append(gen_subscribe_url(hub, callback))

for url in unsubscribe_urls:
    print "unsubscribe", url

for url in subscribe_urls:
    print "subscribe", url

print ""

raw_input("press Enter to start...")

for url in unsubscribe_urls:
    print "unsubscribe", url, urllib2.urlopen(url).read()
    time.sleep(0.5) # because of hub limits

for url in subscribe_urls:
    print "subscribe", url, urllib2.urlopen(url).read()
    time.sleep(0.5) # because of hub limits


print "complete"
