#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

metrics_awk='
@include "/usr/share/yandex-mail-common/metrics-util.awk"

BEGIN {
    print "total 0"
    print "codes.total.200 0"
    print "codes.total.101 0"
    print "codes.total.400 0"
    print "codes.total.401 0"
    print "codes.total.429 0"
    print "codes.total.500 0"
    print "codes.total.502 0"
    print "codes.total.503 0"
    print "codes.total.504 0"
}
/\trequest=/ {
    parse(a)

    # HACK ignore 501 HEAD
    if (a["method"] == "HEAD" && a["code"] == 501) next

    if (a["request"] ~ "notify_") a["request"] = "notify"
    if (a["request"] ~ "webpushapi_send_") a["request"] = "webpushapi_send"
    if (a["api_group"] && a["api_result"]) {
        print format("{}.codes.{} {}", a["api_group"], a["api_result"], 1)
    }

    split(a["service"], services, ",")
    if (length(services) == 0) {
        services[0]="unknown"
    }

    for (i in services) {
        a["service"] = services[i]

        if (a["x_request_attempt"] + 0 == a["x_request_attempt"]) {
            # values from datasync are invalid
            if (a["service"] != "datasync") {
                print format("attempts.total.{} {} {}", a["x_request_attempt"], 1, a["service"])
                print format("attempts.by_request.{}.{} {} {}", a["request"], a["x_request_attempt"], 1, a["service"])
            }
        }

        if (a["status_code"] ~ /2../ || a["status_code"] ~ /100./) {
            print format("timings.{} {} {}", a["request"], a["profiler_exec"], a["service"])
            print format("timings.total {} {}", a["profiler_exec"], a["service"])
        }

        if (length(a["status_code"]) > 3) continue

        print format("total {} {}", 1, a["service"])
        print format("codes.{}.{} {} {}", a["request"], a["status_code"], 1, a["service"])
        print format("codes.service_total.{} {} {}", a["status_code"], 1, a["service"])
        print format("codes.service_total.{}.{} {} {}", a["service"], a["status_code"], 1, a["service"])

        for (j in a) {
            if (j ~ /^batch_[0-9x]+/) {
                print format("batch_codes.service_total.{} {} {}", j, a[j], a["service"])
            }
        }
    }
}
'

log_file="/var/log/$QLOUD_APPLICATION/access.log"
aggregate_awk="/usr/share/yandex-mail-common/metrics-aggregate.awk"

timetail -n 30 -r 'timestamp=.{11}(\d\d:\d\d:\d\d)' "$log_file" | head -n -1 | \
    awk -F $'\t' "$metrics_awk" | awk -v multiplier=2 -f "$aggregate_awk" | \
    awk -v ts="$(date +%s)" '{print "http."$1, $2, ts, $3}'

log_file="/var/log/$QLOUD_APPLICATION/rpc.log"

timetail -n 30 -r 'timestamp=.{11}(\d\d:\d\d:\d\d)' "$log_file" | head -n -1 | \
    awk -F $'\t' "$metrics_awk" | awk -v multiplier=2 -f "$aggregate_awk" | \
    awk -v ts="$(date +%s)" '{print "rpc."$1, $2, ts, $3}'
