#! /bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"
nc localhost 8091 | python3 -c "
import sys
import json
stat = json.loads(sys.stdin.read())
print('connections', stat['stat']['modules']['processor']['subscribers'])
" | awk  -v ts="$(date +%s)" '{print $1, $2, ts}' | sed 's/stable_qloud_d_yandex_net_//g' | \
    egrep '^[[:alnum:][:space:]._-]+$' | awk 'NF==3 && $2+0==$2 { print tolower($0) }'