#!/bin/bash

[[ "$TRACE" ]] && set -x
set -eo pipefail

PATH="/usr/sbin:/usr/bin:/sbin:/bin"

metrics_awk='
@include "/usr/share/yandex-mail-common/metrics-util.awk"

/group=notifications/ {
    parse(a)
    if (a["action"] != "send") next;
    if (!a["service"]) next;
    print format("notifications.by_service.total {} {}", 1, a["service"])
    print format("notifications.by_service.{} {} {}", a["service"], 1, a["service"])
    if (a["event"]) {
        print format("notifications.by_event.{}_{} {} {}", a["service"], a["event"], 1, a["service"])
    }
    if (a["client"]) {
        print format("notifications.by_client.{}_{} {} {}", a["client"], a["service"], 1, a["service"])
    }
}

/group=rproxy/ {
    parse(a)
    if (a["event"] != "request") next;
    rproxy_requests_by_session[a["connection"]] += 1
    print format("rproxy.requests.total {} {}", 1, a["service"])
    print format("rproxy.requests.protocol_code.{} {} {}", a["protocol_code"], 1, a["service"])
    print format("rproxy.requests.bytes_in {} {}", a["request_bytes"], a["service"])
    print format("rproxy.frames.bytes_in_hgram {} {}", a["request_bytes"], a["service"])
    if (a["response_bytes"] != 0) {
        print format("rproxy.requests.bytes_out {} {}", a["response_bytes"], a["service"])
        print format("rproxy.frames.bytes_out_hgram {} {}", a["response_bytes"], a["service"])
    }
    if (a["http_code"] != 0) {
        print format("rproxy.requests.http_code.{} {} {}", a["http_code"], 1, a["service"])
    }
    if (a["backend_time"] != 0) {
        print format("rproxy.requests.timings.backend {} {}", a["backend_time"], a["service"])
    }
    if (a["protocol_code"] != "success") {
        print format("rproxy.errors.total {} {}", 1, a["service"])
        if (length(a["private_error"]) && a["private_error"] != "success") {
            print format("rproxy.errors.reason.{} {} {}", a["private_error"], 1, a["service"])
        }
    }
}

END {
    requests_per_session = ""
    for (session in rproxy_requests_by_session) {
        requests_per_session = requests_per_session  ","  rproxy_requests_by_session[session]
    }
    sub(",", "", requests_per_session)
    print format("rproxy.requests.per_session_hgram {}", requests_per_session)
}
'

log_file="/var/log/$QLOUD_APPLICATION/typed.log"
aggregate_awk="/usr/share/yandex-mail-common/metrics-aggregate.awk"

timetail -n 30 -r 'timestamp=.{11}(\d\d:\d\d:\d\d)' "$log_file" | head -n -1 | \
    awk -F $'\t' "$metrics_awk" | awk -v multiplier=2 -f "$aggregate_awk" | \
    awk -v ts="$(date +%s)" '{print $1, $2, ts, $3}'