#pragma once

#include "processor/subscriber.h"
#include "web/channel_key.h"
#include <yxiva/core/types.h>
#include <yxiva/core/message.h>
#include <yxiva/core/user_info.h>
#include <yxiva/core/map_utils.h>
#include <yplatform/module.h>
#include <yplatform/log/typed.h>
#include <yplatform/task_context.h>

#define TYPED_N YLOG((*logger_), info) << root_am_notifications
#define TYPED_S YLOG((*logger_), info) << root_am_subscriptions
#define TYPED_CH YLOG((*logger_), info) << root_am_channels
#define TYPED YLOG((*logger_), info)

#define make_context_attr(name, ctx) ll::make_attr(name, ctx ? ctx->uniq_id() : "")

namespace yxiva {

namespace ll = yplatform::log::typed;

class xivaws_log : public yplatform::module
{
public:
    void init(const yplatform::ptree& conf);

    void log_subscriber_add(const string& uid, const channel_key& key, const string& subscriber);
    void log_subscriber_del(const string& uid, const channel_key& key, const string& subscriber);
    void log_subscriber_del(const string& uid, const string& service, const string& subscriber);
    void log_channel_state(
        const string& uid,
        const channel_key& key,
        const string& state,
        const string& subscription_id);
    // @todo modify class subscriber - ctx is not const
    void log_notification(
        task_context_ptr ctx,
        const string& subscription_id,
        /*const */ subscriber& subscriber,
        const message& message);
    void log_notification(
        task_context_ptr send_ctx,
        task_context_ptr client_ctx,
        const message& message);
    void log_notification_skip(task_context_ptr ctx, const message& message, const string& info);
    void log_notification_ack(
        task_context_ptr ctx,
        const string& send_context,
        const string& transit_id,
        const string& client,
        const string& service);

    void log_rproxy_request(
        task_context_ptr ctx,
        const string& protocol_code,
        const string& service,
        uint64_t reqid,
        const string& private_error,
        size_t request_bytes,
        size_t response_bytes = 0,
        int http_code = 0,
        const time_duration& backend_time = time_duration::zero());

private:
    void parse_notification_fields(string const& log_notification_fields_str);
    void log_message(const message& message, std::stringstream& ss);
    void log_map_fields(const std::map<string, string>& map, ll::attributes_map& am);
    ll::attributes_map make_attrs(const channel_key& key);
    ll::attributes_map make_attrs(const message& message);
    string channel_full_name(const channel_key& key) const;

private:
    ll::attributes_map root_am_notifications;
    ll::attributes_map root_am_subscriptions;
    ll::attributes_map root_am_channels;
    std::vector<string> log_notification_fields_;
    boost::optional<yplatform::log::tskv_logger> logger_;
};

}
