#pragma once

#include "settings.h"
#include "stats.h"
#include "subscriber.h"
#include <yxiva/core/types.h>

#include <boost/optional.hpp>
#include <map>

namespace yxiva {

class catalogue : public enable_shared_from_this<catalogue>
{
public:
    using uid_service = std::pair<string, string>;
    using subscribers = std::map<uid_service, std::map<string, subscriber_ptr>>;

    bool add(const string& uid, const string& service, const string& id, subscriber_ptr subscriber);
    bool del(const string& uid, const string& service, const string& id);
    std::size_t del_by_subscriber_id(
        const string& uid,
        const string& service,
        const string& subscriber_id);
    void clear();

    std::vector<subscriber_ptr> find_by_uid_service(const string& uid, const string& service);
    subscriber_ptr find_by_id(const string& uid, const string& service, const string& id);

    frontend_stat_ptr stat();
    void write_overview(std::ostream& stream);

private:
    mutable mutex mutex_;
    frontend_stat_ptr stat_{ new frontend_stat };
    subscribers subscribers_;
};

typedef shared_ptr<catalogue> catalogue_ptr;

}
