#include "impl.h"

#include "untyped_ctx.h"
#include <boost/range/adaptor/map.hpp>
#include <ymod_webserver/server.h>
#include <yplatform/encoding/url_encode.h>
#include <yplatform/find.h>
#include "web/formatters/json.h"
#include "web/formatters/daria.h"
#include <yxiva/core/services/msgpack_decoder.h>
#include <yxiva/core/services/simple_http_decoder.h>
#include <yxiva/core/services/csv_decoder.h>
#include <ymod_xconf/http_client.h>

namespace yxiva { namespace processor {

processor_impl::processor_impl()
{
}

void processor_impl::init(const yplatform::ptree& xml)
{
    settings_->parse_ptree(xml);

    authorizer_.reset(new authorizer_blackbox());
    catalogue_.reset(new yxiva::catalogue);

    decoders_ = { { "csv", std::make_shared<services::csv_decoder>("csv") },
                  { "msgpack", std::make_shared<services::msgpack_decoder>("msgpack") },
                  { "basic-http", std::make_shared<services::simple_http_decoder>("basic-http") } };

    formatters_.reset(new formatters::kit());
    formatters_->add("daria", formatters::formatter_ptr(new formatters::daria));
    formatters_->add("json", formatters::formatter_ptr(new formatters::json));
}

void processor_impl::start()
{
}

void processor_impl::stop()
{
    scoped_lock lock(mux_);
    catalogue_->clear();
    catalogue_.reset();
}

void processor_impl::fini(void)
{
}

catalogue_ptr processor_impl::catalogue()
{
    scoped_lock lock(mux_);
    return catalogue_;
}

} // namespace processor
} // namespace yxiva

#include <yplatform/module_registration.h>
DEFINE_SERVICE_OBJECT(yxiva::processor::processor_impl)
