#pragma once

#include <boost/thread.hpp>
#include <map>
#include <yplatform/find.h>
#include <yplatform/log.h>

#include <yxiva/core/types.h>
#include <yxiva/core/services/decoder_interface.h>
#include "catalogue.h"
#include "settings.h"
#include "interface.h"

namespace yxiva { namespace processor {

class processor_impl
    : public yplatform::module
    , public processor
{
public:
    processor_impl();

    void init(const yplatform::ptree& xml);
    void start();
    void stop();
    void fini(void);

    catalogue_ptr catalogue() override;

    authorizer_ptr authorizer() override
    {
        return authorizer_;
    }

    std::shared_ptr<services::decoder_interface> decoder(const string& name) override
    {
        auto it = decoders_.find(name);
        return it == decoders_.end() ? nullptr : it->second;
    }

    formatters::kit_ptr formatters() override
    {
        return formatters_;
    }

    settings_ptr settings() override
    {
        return settings_;
    }

    yplatform::ptree get_stats() const override
    {
        auto catalogue_stats = catalogue_->stat();
        yplatform::ptree ret;
        ret.put("subscribers", catalogue_stats->get_subscribers());
        auto service_iterators = catalogue_stats->get_service_iterators();
        yplatform::ptree map;
        for (auto it : service_iterators)
        {
            auto&& [service, counter] = *it;
            map.put(service, counter.load());
        }
        ret.add_child("service_subscribers", map);
        return ret;
    }

private:
    mutex mux_;
    catalogue_ptr catalogue_;
    authorizer_ptr authorizer_;
    std::map<string, std::shared_ptr<services::decoder_interface>> decoders_;
    formatters::kit_ptr formatters_;
    settings_ptr settings_{ new struct settings };
};

} // namespace processor
} // namespace yxiva
