#pragma once

#include <vector>
#include <yxiva/core/types.h>
#include <yxiva/core/authorizer.h>
#include "web/formatters/kit.h"
#include <yxiva/core/services/decoder_interface.h>
#include "settings.h"
#include "catalogue.h"

namespace yxiva { namespace processor {

class processor
{
public:
    virtual catalogue_ptr catalogue() = 0;
    virtual authorizer_ptr authorizer() = 0;
    virtual std::shared_ptr<services::decoder_interface> decoder(const string& name) = 0;
    virtual formatters::kit_ptr formatters() = 0;
    virtual settings_ptr settings() = 0;
    virtual ~processor()
    {
    }
};

typedef std::shared_ptr<processor> processor_ptr;
typedef std::weak_ptr<processor> processor_weak_ptr;

}}
