#include "settings.h"

#include <yplatform/ptree.h>

namespace yxiva { namespace processor {

void settings::parse_ptree(const yplatform::ptree& conf)
{
    resubscribe_interval = hours(conf.get("resubscribe_interval.<xmlattr>.h", 24)) +
        minutes(conf.get("resubscribe_interval.<xmlattr>.m", 0)) +
        seconds(conf.get("resubscribe_interval.<xmlattr>.s", 0));
    resubscribe_inactive_interval =
        hours(conf.get("resubscribe_inactive_interval.<xmlattr>.h", 0)) +
        minutes(conf.get("resubscribe_inactive_interval.<xmlattr>.m", 30)) +
        seconds(conf.get("resubscribe_inactive_interval.<xmlattr>.s", 0));
    min_subscribe_retry_interval = hours(conf.get("min_subscribe_retry_interval.<xmlattr>.h", 0)) +
        minutes(conf.get("min_subscribe_retry_interval.<xmlattr>.m", 1)) +
        seconds(conf.get("min_subscribe_retry_interval.<xmlattr>.s", 0));
    max_subscribe_retry_interval = hours(conf.get("max_subscribe_retry_interval.<xmlattr>.h", 0)) +
        minutes(conf.get("max_subscribe_retry_interval.<xmlattr>.m", 5)) +
        seconds(conf.get("max_subscribe_retry_interval.<xmlattr>.s", 0));
    watch_subscribers_resubscribe_interval =
        conf.get<time_duration>("watch_subscribers.resubscribe_interval");
    watch_subscribers_min_subscribe_retry_interval =
        conf.get<time_duration>("watch_subscribers.min_subscribe_retry_interval");
    watch_subscribers_max_subscribe_retry_interval =
        conf.get<time_duration>("watch_subscribers.max_subscribe_retry_interval");
    string prefix = conf.get("prefix", "");
    string suffix = conf.get("suffix", ":1080/notify");
    ignore_subscribe = (conf.get("ignore_subscribe", "0") == "1");
    {
        const int buff_size = 256;
        char buff[buff_size];
        if (gethostname(buff, 256) == 0) host_name.assign(buff);
        else
            throw std::runtime_error("processor_impl::init: can't get hostname");
    }

    auto ttl_conf = conf.get_child_optional("preset_ttl");
    if (ttl_conf)
    {
        ttl.default_value = ttl_conf->get("<xmlattr>.default", 8);
        for (auto it = ttl_conf->begin(); it != ttl_conf->end(); ++it)
        {
            if (it->first == "ttl")
            {
                string client = it->second.get<string>("<xmlattr>.client");
                ttl_t value = it->second.get_value(ttl.default_value);
                ttl.add(client, value);
            }
            else if (it->first != "<xmlattr>")
            {
                L_(warning) << "unknown block inside 'preset_ttl' name=\"" << it->first << "\"";
            }
        }
    }
    else
    {
        L_(warning) << "missing settings block 'preset_ttl'";
    }

    notify_url =
        conf.get("scheme", "https") + "://" + (prefix.empty() ? host_name : prefix) + suffix;
    max_tags_per_service = conf.get<unsigned>("max_tags_per_service", 20);
}

}}
