#pragma once

#include "settings.h"
#include <yxiva/core/types.h>
#include <yxiva/core/context.h>

namespace yxiva { namespace processor {

struct settings
{
    struct preset_ttl
    {
        ttl_t default_value;

        void add(const string& name, ttl_t value)
        {
            special[name] = value;
        }

        ttl_t get(const string& client)
        {
            auto found = special.find(client);
            return found == special.end() ? default_value : found->second;
        }

    private:
        std::map<string, ttl_t> special;
    };

    settings() : ctx(new context), ignore_subscribe(false)
    {
    }

    void parse_ptree(const yplatform::ptree& conf);

    context_ptr ctx;

    string host_name;
    string notify_url;
    bool ignore_subscribe;
    time_duration resubscribe_interval;
    time_duration resubscribe_inactive_interval;
    time_duration min_subscribe_retry_interval;
    time_duration max_subscribe_retry_interval;
    // TODO merge with web/settings
    time_duration watch_subscribers_resubscribe_interval;
    time_duration watch_subscribers_min_subscribe_retry_interval;
    time_duration watch_subscribers_max_subscribe_retry_interval;
    preset_ttl ttl;
    unsigned max_tags_per_service;
};

typedef shared_ptr<settings> settings_ptr;

}}