#pragma once

#include <yxiva/core/types.h>
#include <atomic>

namespace yxiva {

class frontend_stat
{
    using service_subscribers = std::map<string, std::atomic<uint64_t>>;
    using service_subscribers_it = service_subscribers::iterator;

public:
    auto get_subscribers()
    {
        return subscribers_.load();
    }

    void add_subscriber(const std::string& service)
    {
        ++subscribers_;

        scoped_lock lock(mutex_);
        if (service_subscribers_.count(service) == 0)
        {
            auto iter = service_subscribers_.insert(std::make_pair(service, 0)).first;
            service_subs_iterators_.push_back(iter);
        }
        ++service_subscribers_[service];
    }

    void del_subscriber(const std::string& service)
    {
        --subscribers_;

        scoped_lock lock(mutex_);
        if (service_subscribers_.count(service) > 0)
        {
            --service_subscribers_[service];
        }
    }

    auto get_service_iterators()
    {
        scoped_lock lock(mutex_);
        return service_subs_iterators_;
    }

private:
    mutable mutex mutex_;
    std::atomic<uint64_t> subscribers_ = { 0 };
    service_subscribers service_subscribers_;
    std::vector<service_subscribers_it> service_subs_iterators_;
};

typedef shared_ptr<frontend_stat> frontend_stat_ptr;

}
