#pragma once

#include "web/messages.h"
#include <yxiva/core/types.h>
#include <yxiva/core/user_info.h>
#include <yxiva/core/message.h>

namespace yxiva {

class subscriber
{
public:
    virtual ~subscriber()
    {
    }
    virtual void notify(
        const user_info& info,
        const message& message,
        const string& context_id) = 0;
    virtual void notify_plain_text(const string&) = 0;
    virtual void notify_connected(const web::connected_message&)
    {
    }
    virtual void notify_disconnected(const web::disconnected_message&)
    {
    }
    virtual void notify_position(const web::position_message&)
    {
    }
    virtual void notify_error(const web::error_message&)
    {
    }
    virtual void ping(const web::ping_message&)
    {
    }
    virtual yplatform::task_context_ptr ctx() const = 0;
    virtual string id() const;
    virtual string const& client_id() const;
    virtual bool is_expired() const
    {
        return false;
    }
    virtual void close()
    {
    }
};

typedef shared_ptr<subscriber> subscriber_ptr;
typedef weak_ptr<subscriber> subscriber_weak_ptr;

}
