#pragma once

#include "settings.h"
#include <ymod_httpclient/cluster_client.h>
#include <yplatform/algorithm/leaky_bucket.h>

namespace yxiva {

struct rproxy_rate_limit
{
    rproxy_rate_limit(rproxy_rate_limit_settings settings)
        : settings(settings)
        , requests_counter(settings.recovery_rate, settings.recovery_interval_ms)
    {
    }

    rproxy_rate_limit_settings settings;
    yplatform::leaky_bucket<uint64_t> requests_counter;
};

struct rproxy_gate_stats
{
    struct
    {
        bool enabled = false;
        size_t limit = 0;
        size_t running = 0;
    } rate_limit;
    time_point update_ts = clock::now();
};

struct rproxy_gate
{
    yhttp::cluster_client::settings client_settings;
    std::shared_ptr<yhttp::cluster_client> client;
    std::optional<rproxy_rate_limit> rate_limit;
    rproxy_gate_stats stats;
};

}
