#pragma once

#include "service.h"
#include <yxiva/core/iabstract.h>
#include <yxiva/core/types.h>

namespace yxiva {

using services_type = std::vector<std::shared_ptr<const service_data>>;
using services_callback_t = std::function<void(const operation::result&, services_type)>;
using update_callback_t = std::function<void(const operation::result&)>;
// Returns operation result and token value in case of success.
using token_update_callback_t = std::function<void(const operation::result&, const string&)>;
// Returns created service (properties + default tokens)
using create_service_callback_t =
    std::function<void(const operation::result&, std::shared_ptr<service_data>)>;
using service_properties_transform = std::function<service_properties(const service_properties&)>;

class service_manager : public iabstract
{
public:
    virtual std::shared_ptr<const service_data> find_service_by_send_token(
        const string& token) const = 0;

    virtual std::shared_ptr<const service_data> find_service_by_listen_token(
        const string& token) const = 0;

    virtual std::shared_ptr<const service_data> find_service_by_name(const string& name) const = 0;

    virtual std::shared_ptr<const application_config> find_app(
        const string& platform,
        const string& name) const = 0;

    virtual void find_services_by_owner(
        const task_context_ptr& ctx,
        const string& owner,
        const services_callback_t& cb) = 0;

    // In case of lookup for multiple owners, prevents multiple xconf::list() requests.
    virtual void find_services_by_owners(
        const task_context_ptr& ctx,
        std::shared_ptr<const std::vector<string>> owners,
        const services_callback_t& cb) = 0;

    // Gets all services (needed for admin users).
    virtual void get_all_services(const task_context_ptr& ctx, const services_callback_t& cb) = 0;

    virtual const string& environment() const = 0;

    virtual void update_service_properties(
        task_context_ptr ctx,
        const service_properties& data,
        const update_callback_t& cb) = 0;

    virtual void update_service_properties(
        task_context_ptr ctx,
        const string& service_name,
        const service_properties_transform& transform,
        const update_callback_t& cb) = 0;

    virtual void update_send_token(
        task_context_ptr ctx,
        const string& env_str,
        const send_token_properties& data,
        const string& service_owner,
        const token_update_callback_t& cb) = 0;

    virtual void update_listen_token(
        task_context_ptr ctx,
        const string& env_str,
        const listen_token_properties& data,
        const string& service_owner,
        const token_update_callback_t& cb) = 0;

    virtual void create_service(
        task_context_ptr ctx,
        const service_properties& data,
        const create_service_callback_t& cb) = 0;

    virtual void update_app(
        task_context_ptr ctx,
        const application_config& data,
        const string& service_owner,
        const update_callback_t& cb) = 0;
};

using service_manager_ptr = std::shared_ptr<service_manager>;

}
