#pragma once

#include <yxiva/core/types.h>
#include <yxiva/core/conf.h>
#include <yplatform/util/sstream.h>
#include <map>
#include <set>

namespace yxiva {
// Represents the whole service. Tokens are stored as respective string values,
// as no additional information is required yet.
struct service_data
{
    // std::pair as a map key causes a lot of *.first.second code,
    // custom key type is more readable.
    struct key_t
    {
        // Contains unchanged token (with legacy prefix, if there was any).
        string source_token;
        string env;
        string token;

        key_t(const string& t, const string& e) : source_token(t), env(e)
        {
            if (source_token.find(':') == env.size() &&
                source_token.compare(0, env.size(), env) == 0)
            {
                token = source_token.substr(env.size() + 1);
            }
            else
            {
                token = source_token;
            }
        }

        bool operator<(const key_t& other) const
        {
            return std::tie(token, env) < std::tie(other.token, other.env);
        }
    };

    using stoken_map_t = std::map<key_t, send_token_properties>;
    using ltoken_map_t = std::map<key_t, listen_token_properties>;

    service_properties properties;
    stoken_map_t send_tokens;
    ltoken_map_t listen_tokens;
    // Key is {platform, app_name}.
    std::map<std::tuple<string, string>, application_config> apps;
};

}
