#include "send.h"

#include "parse_helpers.h"
#include "web/hacks.h"
#include "web/methods/hub_routines.h"
#include <yxiva/core/iabstract.h>
#include <yplatform/find.h>

namespace yxiva { namespace web { namespace api {

struct args
{
    string uid;
    string event;
    string tags;
    string local_id;
    string ttl;
};

void send(http_stream_ptr stream, settings_ptr settings, const service_authorization& auth)
{
    // TODO: CHECK HTTPS

    auto arguments = boost::make_shared<args>();

    if (!params::parser<
            params::uid,
            params::event,
            params::optional_tags_list,
            params::optional_local_id,
            params::optional_ttl>::fill(stream, arguments))
        return;

    auto tags_count = std::count(arguments->tags.begin(), arguments->tags.end(), ',');
    if (tags_count >= settings->api.message_max_tags)
    {
        send_bad_request(stream, "too many tags");
        return;
    }

    auto body = string(stream->request()->raw_body.begin(), stream->request()->raw_body.end());
    if (body.size() >= settings->api.message_max_payload &&
        !settings->service_features.message_unlimited_payload.enabled_for(auth.service.name))
    {
        send_bad_request(stream, "payload too large");
        return;
    }

    // TODO check here if an event is allowed

    find_hubrpc()->async_post(
        stream->ctx(),
        arguments->uid,
        "/notify/" + auth.service.name,
        { { "uid", arguments->uid },
          { "service", auth.service.name },
          { "operation", arguments->event },
          { "lcn", arguments->local_id },
          { "ttl", arguments->ttl },
          { "tags", arguments->tags },
          { "priority", "high" } },
        std::move(body),
        handle_default_hub_codes(stream));
}

}}}
