#pragma once

#include "../types.h"
#include <ymod_webserver/websocket.h>
#include <ymod_webserver/methods/default_answers.h>

namespace yxiva { namespace web { namespace api {

namespace http_codes = ymod_webserver::codes;
namespace http_response = ymod_webserver::default_answers;

template <typename Stream>
void send_bad_request(Stream& stream, const string& info)
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "bad request: " << info;
    stream->result(http_codes::bad_request, info);
}

template <>
inline void send_bad_request<>(
    ymod_webserver::websocket::output_stream_ptr& stream,
    const string& info)
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "bad request: " << info;
    json_value message;
    message["error"] = info;
    stream->close_connection(websocket_codes::bad_request, message.stringify());
}

template <typename Stream>
void send_unauthorized(Stream& stream, const string& info)
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "unauthorized: " << info;
    stream->result(http_codes::unauthorized, info);
}

template <>
inline void send_unauthorized<>(
    ymod_webserver::websocket::output_stream_ptr& stream,
    const string& info)
{
    YLOG_CTX_GLOBAL(stream->ctx(), info) << "unauthorized: " << info;
    json_value message;
    message["error"] = info;
    stream->close_connection(websocket_codes::unauthorized, message.stringify());
}

}}}
