#include "subscribe_url.h"

#include "common.h"
#include "parse_helpers.h"
#include "web/extract_requests.h"
#include "web/methods/hub_routines.h"
#include "web/utils/bb_connection_id.h"
#include <yxiva/core/iabstract.h>
#include <yxiva/core/http_handlers.h>
#include <yxiva/core/subscription_id.h>
#include <yplatform/find.h>

namespace yxiva { namespace web { namespace api {

namespace {

struct args
{
    string uid;
    string service;
    string filter;
    string session;
    string callback;
};

void handle_subscribe_url_proxy_call(
    const boost::system::error_code& err,
    yhttp::response response,
    http_stream_ptr stream,
    ttl_t ttl) noexcept
{
    if (err || response.status != 200)
    {
        handle_default_hub_codes(stream, yhttp::errc(), response);
        return;
    }

    json_value value;
    value["subscription-id"] = response.body;
    value["ttl"] = ttl;
    stream->result(http_codes::ok, value.stringify());
}
}

bool subscribe_url(
    http_stream_ptr stream,
    settings_ptr /*settings*/,
    const service_authorization& auth,
    const service_with_filter& service)
{
    auto arguments = boost::make_shared<args>();

    if (!params::parser<params::uid, params::session, params::callback>::fill(stream, arguments))
        return true;

    string client = auth.client;
    ttl_t ttl = find_processor()->settings()->ttl.get(client);
    auto subscription_id = make_subscription_id(
        arguments->uid,
        service.name,
        arguments->callback,
        client,
        arguments->session,
        service.filter,
        {});

    namespace p = std::placeholders;
    find_hubrpc()->async_post(
        stream->ctx(),
        arguments->uid,
        "/subscribe",
        { { "uid", arguments->uid },
          { "callback", arguments->callback },
          { "service", service.name },
          { "client", client },
          { "session_key", arguments->session },
          { "ttl", ttl },
          { "account", arguments->uid },
          { "bb_connection_id", get_bb_connection_id(stream) },
          { "id", subscription_id } },
        string(service.filter.empty() ? string() : "filter=" + url_encode(service.filter)),
        std::bind(handle_subscribe_url_proxy_call, p::_1, p::_2, stream, ttl));

    return true;
}

}}}
