#include "subscriptions_user.h"

#include "common.h"
#include "parse_helpers.h"
#include "web/extract_requests.h"
#include "web/methods/hub_routines.h"
#include <yxiva/core/iabstract.h>
#include <yxiva/core/http_handlers.h>
#include <yplatform/find.h>

namespace yxiva { namespace web { namespace api {

namespace {

struct args
{
    string uid;
};

void handle_list_url_proxy_call(
    const boost::system::error_code& err,
    yhttp::response response,
    http_stream_ptr stream)
{
    if (err || response.status != 200)
    {
        handle_default_hub_codes(stream, yhttp::errc(), response);
        return;
    }

    json_value result(json_type::tarray);

    try
    {
        json_value list;
        if (auto error = list.parse(response.body, json_type::tarray))
        {
            throw std::runtime_error(*error);
        }

        for (auto&& list_item : list.array_items())
        {
            json_value result_item;
            result_item["id"] = list_item["id"];
            result_item["url"] = list_item["url"];
            result_item["client"] = list_item["client"];
            result_item["ttl"] = list_item["ttl"];
            result_item["session"] = list_item["session_key"];
            result.push_back(result_item);
        }
    }
    catch (const std::exception& e)
    {
        YLOG_CTX_GLOBAL(stream->ctx(), error)
            << "hub list result parse exception=\"" << e.what() << "\"";
        stream->result(http_codes::internal_server_error);
        return;
    }
    catch (...)
    {
        YLOG_CTX_GLOBAL(stream->ctx(), error) << "hub list result parse exception=\"unknown\"";
        stream->result(http_codes::internal_server_error);
        return;
    }

    stream->result(http_codes::ok, json_write_styled(result));
}
}

bool subscriptions_user(
    http_stream_ptr stream,
    settings_ptr /*settings*/,
    const service_authorization& auth)
{
    auto arguments = boost::make_shared<args>();

    if (!params::parser<params::uid>::fill(stream, arguments)) return true;

    namespace p = std::placeholders;
    find_hubrpc()->async_get(
        stream->ctx(),
        arguments->uid,
        "/list_json",
        { { "uid", arguments->uid }, { "service", auth.service.name }, { "priority", "high" } },
        std::bind(handle_list_url_proxy_call, p::_1, p::_2, stream));

    return true;
}

}}}
