#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace api2 {

struct subscribe_sse
{
    settings_ptr settings;
    subscribe_sse(settings_ptr st) : settings(st)
    {
    }
    void operator()(
        http_stream_ptr stream,
        const std::vector<string>& uids,
        const string& topic,
        const service_with_filter_list& service,
        const string& client,
        const string& session,
        const string& secret_sign,
        const std::time_t sign_ts,
        const fetch_history& history,
        const fetch_history& history_strict,
        const string& filter);
};

struct subscribe_websocket
{
    settings_ptr settings;
    subscribe_websocket(settings_ptr st) : settings(st)
    {
    }
    void operator()(
        websocket_stream_ptr stream,
        const std::vector<string>& uids,
        const string& topic,
        const service_with_filter_list& services,
        const string& client,
        const string& session,
        const string& secret_sign,
        const std::time_t sign_ts,
        const fetch_history& history,
        const fetch_history& history_strict,
        const string& filter);
};

struct subscribe_websocketapi
{
    settings_ptr settings;
    subscribe_websocketapi(settings_ptr st) : settings(st)
    {
    }
    void operator()(
        std::shared_ptr<websocket_rpc::stream> stream,
        const string& uid,
        const string& topic,
        const service_with_filter& service,
        const string& client,
        const string& session,
        const string& secret_sign,
        const std::time_t sign_ts,
        const fetch_history& history,
        const fetch_history& history_strict,
        const string& filter);
};

}}}
