#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace api2 {

struct subscribe_app
{
    settings_ptr settings;

    http_stream_ptr stream;
    settings_ptr unused; /* XXX settings from auth handler TODO remove*/
    varying_authorization auth;
    service_with_filter service;
    string uid;
    string filter;
    string app_name;
    string push_token;
    string uuid;
    string platform;
    string extra;
    string client;
    string device_id;
    string topic;

    bool use_apns_queue = false;

    using yield_ctx = yplatform::yield_context<subscribe_app>;

    void operator()(yield_ctx, const error_code& = {}, yhttp::response = {});

    void do_subscribe_apns_queue(yield_ctx);

    void do_subscribe_apns_queue_reference(yield_ctx);

    void do_subscribe_app(yield_ctx);

    void respond(const error_code& err, const yhttp::response& response);

    bool subscription_id_required() const;

    void add_subscription(
        const service_with_filter& service,
        const string& uid,
        const string& callback,
        const string& uuid,
        const string& platform,
        const string& extra,
        const string& client,
        const string& device_id,
        const string& topic,
        const string& connection_id,
        yield_ctx);

    unsigned ttl_for(const string& platform);

    string bb_connection_id();
};

}}}
