#pragma once

#include "common.h"
#include "web/settings.h"

namespace yxiva { namespace web { namespace api2 {

struct subscribe_webpush
{
    settings_ptr settings;

    http_stream_ptr stream;
    settings_ptr unused; /* XXX settings from auth handler TODO remove*/
    service_authorization auth;
    service_with_filter service;
    string uid;
    string client;
    string session;
    string webpush_subscription;
    string raw_filter;
    string extra;
    string topic;
    unsigned ttl;

    using yield_ctx = yplatform::yield_context<subscribe_webpush>;

    void operator()(yield_ctx, const error_code& = {}, yhttp::response = {});

    void respond(const error_code& err, const yhttp::response& response);

    bool subscription_id_required() const;

    operation::result check_ttl(uint32_t ttl) const;
};

}}}
