#include "unsubscribe.h"

#include "web/methods/hub_routines.h"
#include "web/find_deps.h"
#include <yxiva/core/filter.h>
#include <yplatform/find.h>

namespace yxiva { namespace web { namespace api2 {

void unsubscribe(
    http_stream_ptr stream,
    settings_ptr /*settings*/,
    const service_authorization& /*endpoint_conf*/,
    const string& service,
    const string& uid,
    const string& topic,
    const string& subscription_id)
{
    if (uid.empty() && topic.empty())
    {
        send_bad_request(
            stream,
            "request authorized with xiva token must contain either \"uid\" or \"topic\" "
            "arguments");
        return;
    }

    if (uid.size() && topic.size())
    {
        send_bad_request(stream, "request can't contain both \"uid\" and \"topic\" arguments");
        return;
    }

    if (auto result = hacks::is_correct_uid(uid, service); !result)
    {
        send_bad_request(stream, result.error_reason);
        return;
    }

    namespace p = std::placeholders;
    auto metauid = topic.empty() ? uid : encode_topic_name(topic);
    string uidservice = metauid + service;
    find_hubrpc()->async_get(
        stream->ctx(),
        metauid,
        "/unsubscribe",
        { { "uid", metauid },
          { "service", service },
          { "uidservice", uidservice },
          { "subscription-id", subscription_id } },
        handle_default_hub_codes(stream));
}

}}}
