#include "unsubscribe_app.h"
#include "web/methods/hub_routines.h"
#include <yxiva/core/subscription_id.h>

namespace yxiva { namespace web { namespace api2 {

unsubscribe_app::unsubscribe_app(settings_ptr settings) : settings(settings)
{
}

void unsubscribe_app::operator()(
    http_stream_ptr stream,
    settings_ptr /*settings*/,
    const varying_authorization& auth,
    const string& service,
    const string& optional_uid,
    const string& uuid,
    const string& topic)
{
    auto user_auth = get_auth_optional<user_authorization>(auth);
    if (user_auth && topic.size())
    {
        return send_bad_request(stream, "topics are not supported for OAuth authentication method");
    }
    string uid = user_auth ? user_auth->uid : optional_uid;
    if (uid.empty() && topic.empty())
    {
        send_bad_request(
            stream,
            "request authorized with xiva token must contain either \"uid\" or \"topic\" "
            "arguments");
        return;
    }

    if (uid.size() && topic.size())
    {
        send_bad_request(stream, "request can't contain both \"uid\" and \"topic\" arguments");
        return;
    }

    if (auto result = hacks::is_correct_uid(optional_uid, service); !result)
    {
        send_bad_request(stream, result.error_reason);
        return;
    }

    auto metauid = topic.empty() ? uid : encode_topic_name(topic);
    string uidservice = metauid + service;
    find_hubrpc()->async_get(
        stream->ctx(),
        metauid,
        "/unsubscribe",
        { { "uid", metauid },
          { "service", service },
          { "uidservice", uidservice },
          { "subscription-id", make_mobile_subscription_id(uuid) },
          { "priority", "high" } },
        handle_default_hub_codes(stream));
}

}}}
