#include "unsubscribe_webpush.h"

#include "web/methods/hub_routines.h"
#include <yxiva/core/callbacks.h>
#include <yxiva/core/subscription_id.h>

namespace yxiva { namespace web { namespace api2 {

unsubscribe_webpush::unsubscribe_webpush(settings_ptr settings) : settings(settings)
{
}

void unsubscribe_webpush::operator()(
    http_stream_ptr stream,
    settings_ptr /*settings*/,
    const service_authorization& /*auth*/,
    const string& service,
    const string& uid,
    const string& session,
    const string& topic)
{
    if (uid.empty() && topic.empty())
    {
        send_bad_request(stream, "request must contain either \"uid\" or \"topic\" arguments");
        return;
    }

    if (uid.size() && topic.size())
    {
        send_bad_request(stream, "request can't contain both \"uid\" and \"topic\" arguments");
        return;
    }

    if (auto result = hacks::is_correct_uid(uid, service); !result)
    {
        send_bad_request(stream, result.error_reason);
        return;
    }

    auto metauid = topic.empty() ? uid : encode_topic_name(topic);
    string uidservice = metauid + service;
    find_hubrpc()->async_get(
        stream->ctx(),
        metauid,
        "/unsubscribe",
        { { "uid", metauid },
          { "service", service },
          { "uidservice", uidservice },
          { "subscription-id", make_webpush_subscription_id(session) },
          { "priority", "high" } },
        handle_default_hub_codes(stream));
}

}}}
