#include "unsubscribe_websocket.h"
#include "web/auth/cookie.h"
#include "web/auth/secure_sign.h"

namespace yxiva::web::api2 {

void unsubscribe_websocket_impl(
    std::shared_ptr<websocket_rpc::stream> stream,
    settings_ptr,
    const auth_info&,
    const string& uid,
    const string& topic,
    const string& service,
    const string& subscription_token)
{
    string uid_or_topic = topic.size() ? encode_topic_name(topic) : uid;

    if (auto catalogue = find_processor()->catalogue())
    {
        auto deleted = catalogue->del_by_subscriber_id(uid_or_topic, service, subscription_token);
        if (deleted)
        {
            find_xivaws_log()->log_subscriber_del(uid_or_topic, service, subscription_token);

            json_value result;
            result["operation"] = "detached";
            stream->result_json(http_codes::ok, result);
        }
        else
        {
            stream->result(http_codes::reset_content, "no subscriptions"); // 205
        }
    }
}

unsubscribe_websocketapi::unsubscribe_websocketapi(settings_ptr settings) : settings(settings)
{
    continue_with_cookie_auth =
        auth_with_cookie(settings, unsubscribe_websocket_impl, [](stream_ptr stream) {
            send_unauthorized(stream, "");
        });
}

void unsubscribe_websocketapi::operator()(
    stream_ptr stream,
    const string& uid,
    const string& topic,
    const string& service,
    const string& subscription_token,
    const string& secret_sign,
    const std::time_t sign_ts) const
{
    if (uid.empty() && topic.empty())
    {
        return send_bad_request(
            stream, "request should contain any of \"uid\" or \"topic\" argument");
    }

    if (secret_sign.size())
    {
        auto valid_sign = make_secure_sign(
            services_uids_topic_data({ service }, { uid }, topic), sign_ts, settings->sign_secret);
        if (std::time(nullptr) >= sign_ts || valid_sign != secret_sign)
        {
            send_unauthorized(stream, "bad sign");
            return;
        }

        auth_info dummy;
        unsubscribe_websocket_impl(
            stream, settings, dummy, uid, topic, service, subscription_token);
    }
    else
    {
        continue_with_cookie_auth(stream, uid, topic, service, subscription_token);
    }
}
}
