#pragma once

#include "common.h"
#include "web/websocket_rpc_subscriber.h"

namespace yxiva::web::api2 {
struct unsubscribe_websocketapi
{
    using stream_ptr = std::shared_ptr<websocket_rpc::stream>;
    settings_ptr settings;

    // Ensure all calls to the method are within cookie_auth's lifetime.
    std::function<void(stream_ptr, const string&, const string&, const string&, const string&)>
        continue_with_cookie_auth;

    unsubscribe_websocketapi(settings_ptr settings);

    void operator()(
        stream_ptr stream,
        const string& uid,
        const string& topic,
        const string& service,
        const string& subscription_token,
        const string& secret_sign,
        const std::time_t sign_ts) const;
};

}
