#pragma once

#include "common.h"
#include "web/settings.h"

namespace yxiva { namespace web { namespace api2 {

struct vapid_key
{
    string value;

    vapid_key(settings_ptr settings) : value(settings->api.vapid_key)
    {
    }

    void operator()(http_stream_ptr stream)
    {
        stream->set_code(http_codes::ok);
        stream->add_header("Access-Control-Allow-Origin", "*");
        stream->result_body(value);
    }
};

}}}
