#pragma once

#include "common.h"
#include "web/websocket_subscriber.h"

namespace yxiva { namespace web { namespace api2 {

using subscriber_getter_t = std::function<subscriber_ptr(void)>;

struct watch_subscribers_coro
{
    using yield_ctx = yplatform::yield_context<watch_subscribers_coro>;

    boost::asio::io_service* io;
    string service;
    std::vector<string> uids;
    subscriber_getter_t subscriber_getter;
    settings_ptr settings;
    bool batch = true;

    string uids_str = {};
    string last_sent = {};
    std::shared_ptr<std::atomic<bool>> stop{ new std::atomic<bool>{ false } };

    watch_subscribers_coro(
        boost::asio::io_service& io,
        string service,
        std::vector<string> uids,
        subscriber_getter_t subscriber_getter,
        settings_ptr settings)
        : io(&io)
        , service(service)
        , uids(uids)
        , subscriber_getter(subscriber_getter)
        , settings(settings)
    {
    }

    void operator()(
        yield_ctx yield_ctx,
        const boost::system::error_code& ec = {},
        yhttp::response response = {});

    subscriber_ptr get_subscriber()
    {
        return subscriber_getter();
    };
};

struct watch_subscribers
{
    settings_ptr settings;

    // Ensure all calls to the method are within cookie_auth's lifetime.
    std::function<
        void(websocket_stream_ptr, const string& service, const std::vector<string>& topics)>
        continue_with_cookie_auth;

    watch_subscribers(settings_ptr settings);

    void operator()(
        websocket_stream_ptr stream,
        const string& service,
        const std::vector<string>& topics,
        const string& uid,
        const string& secret_sign,
        time_t sign_ts) const;
};

}}}

#include <yplatform/unyield.h>
