#include "fetch_history.h"

#include "uid.h"
#include "service.h"
#include <yplatform/util/split.h>

namespace yxiva { namespace web {

namespace {
bool compare(const fetch_history_item& a, const fetch_history_item& b)
{
    return std::tie(a.uid, a.service) < std::tie(b.uid, b.service);
}

bool equal(const fetch_history_item& a, const fetch_history_item& b)
{
    return std::tie(a.uid, a.service) == std::tie(b.uid, b.service);
}
}

using yplatform::util::split;
using yplatform::util::split_unique;

bool fetch_history_validator::operator()(const string& value) const
{
    static uid_validator uid;
    static service_validator service;
    static auto position = ymod_webserver::default_validator<local_id_t>();
    static auto count = ymod_webserver::default_validator<unsigned>();
    auto items = split_unique(value, ",");
    for (auto& i : items)
    {
        auto subitems = split(i, ":");
        if (subitems.size() != 4 || !uid(subitems[0]) || !service(subitems[1]) ||
            !position(subitems[2]) || !count(subitems[3]))
            return false;
    }
    return true;
}

fetch_history fetch_history_converter::operator()(const string& source) const
{
    auto raw_items = split_unique(source, ",");
    fetch_history result;
    for (auto& i : raw_items)
    {
        auto subitems = split(i, ":");
        if (subitems.size() != 4) throw "invalid fetch history format";
        result.push_back(fetch_history_item{ subitems[0],
                                             subitems[1],
                                             boost::lexical_cast<local_id_t>(subitems[2]),
                                             boost::lexical_cast<unsigned>(subitems[3]) });
    }
    std::sort(result.begin(), result.end(), compare);
    result.erase(std::unique(result.begin(), result.end(), equal), result.end());
    return result;
}

}}
