#pragma once

#include <yxiva/core/types.h>
#include <ymod_webserver/methods/transform.h>
#include <vector>

namespace yxiva { namespace web {

struct fetch_history_item
{
    string uid;
    string service;
    local_id_t position;
    unsigned count;
};

using fetch_history = std::vector<fetch_history_item>;

struct fetch_history_validator
{
    bool operator()(const string& source) const;
};

struct fetch_history_converter
{
    fetch_history operator()(const string& source) const;
};

inline auto fetch_history_argument(const string& name, const std::vector<string>& aliases)
    -> decltype(ymod_webserver::optional_argument<fetch_history>(
        string(),
        std::vector<string>(),
        fetch_history(),
        fetch_history_validator(),
        fetch_history_converter()))
{
    return ymod_webserver::optional_argument<fetch_history>(
        name, aliases, fetch_history(), fetch_history_validator(), fetch_history_converter());
}

inline auto fetch_history_argument(const string& name)
    -> decltype(fetch_history_argument(string(), std::vector<string>()))
{
    return fetch_history_argument(name, { name });
}

}}
