#include "service_and_filter.h"

#include "web/extract_requests.h"

namespace yxiva { namespace web {

operation::result parse_service_with_filter(string& service, string& filter, const string& src)
{
    channels_set channels;
    try
    {
        channels = compose_channels(src, "", "", user_info());
    }
    catch (const std::exception& e)
    {
        return "bad service argument";
    }
    if (channels.size() == 0)
    {
        return "no such service";
    }
    if (channels.size() > 1)
    {
        return "only one service is allowed";
    }

    service = channels[0].service;
    filter = channels[0].filter;
    return operation::success;
}

operation::result parse_filter(string& filter, const string& raw_filter, const settings& settings)
{
    if (filter.size() && raw_filter.size())
        return "allowed only one of: tags (as part of service) or filter";

    if (raw_filter.empty()) return operation::success;

    if (raw_filter.size() > settings.api.max_filter_length) return "filter size limit exceeded";

    filter_set fset;
    auto filter_parsed = filter::parse_v2(fset, raw_filter);
    if (!filter_parsed)
    {
        return "invalid filter: " + filter_parsed.error_reason;
    }
    filter = fset.to_string();

    return operation::success;
}

}}