#pragma once

#include "web/settings.h"

#include <yxiva/core/operation_result.h>
#include <yxiva/core/filter.h>
#include <yxiva/core/split.h>

namespace yxiva { namespace web {

operation::result parse_service_with_filter(string& service, string& filter, const string& src);

operation::result parse_filter(string& filter, const string& raw_filter, const settings& settings);

struct service_with_filter
{
    string name;
    string filter;
};

inline bool operator<(const service_with_filter& a, const service_with_filter& b)
{
    return a.name < b.name;
}

inline bool operator==(const service_with_filter& a, const service_with_filter& b)
{
    return a.name == b.name;
}

typedef std::vector<service_with_filter> service_with_filter_list;

struct service_with_filter_converter
{
    service_with_filter operator()(const string& source) const
    {
        service_with_filter service;
        auto parsed = parse_service_with_filter(service.name, service.filter, source);
        if (!parsed) throw std::runtime_error(parsed.error_reason);
        return service;
    }
};

struct service_with_filter_list_converter
{
    service_with_filter_list operator()(const string& source) const
    {
        auto services = utils::split(source, ",");
        service_with_filter_list result;
        service_with_filter_converter converter;
        for (auto& service : services)
        {
            result.push_back(converter(service));
        }
        return result;
    }
};

}}
