#pragma once

#include <yxiva/core/types.h>
#include <boost/regex.hpp>

namespace yxiva { namespace web {

struct uid_validator
{
    const boost::regex expr;

    uid_validator() : expr("[a-zA-Z0-9][a-zA-Z0-9:@.-]*")
    {
    }

    bool operator()(const string& value) const
    {
        boost::smatch what;
        return value.empty() || boost::regex_match(value, what, expr);
    }
};

struct uid_list_validator
{
    const boost::regex expr;

    uid_list_validator() : expr("[a-zA-Z0-9][a-zA-Z0-9:@.-]*(,[a-zA-Z0-9][a-zA-Z0-9:@.-]*)*")
    {
    }

    bool operator()(const string& value) const
    {
        boost::smatch what;
        return value.empty() || boost::regex_match(value, what, expr);
    }
};

}}