#pragma once

#include <yxiva/core/types.h>

namespace yxiva::web {

template <typename CharValidateFunc>
inline auto validator_with_size(const CharValidateFunc& func, size_t size)
{
    using ymod_webserver::validator;
    return [basic_validator = validator(func), size](const string& value) -> bool {
        return value.size() <= size && basic_validator(value);
    };
}

}