#pragma once

#include <yxiva/core/conf.h>
#include <variant>

namespace yxiva::web {

struct service_authorization
{
    service_properties service;
    string client;
};

using multi_service_authorization = std::vector<service_authorization>;

struct user_authorization
{
    string uid;
    string bb_connection_id;
};

using varying_authorization =
    std::variant<multi_service_authorization, service_authorization, user_authorization>;

template <typename Authorization>
inline std::optional<Authorization> get_auth_optional(const varying_authorization& v)
{
    if (std::holds_alternative<Authorization>(v))
    {
        return std::get<Authorization>(v);
    }
    return {};
}

}
