#pragma once

#include "web/auth/error.h"
#include "web/auth/authorization.h"

namespace yxiva::web::auth {

template <typename Authorization, typename... Methods>
struct chain;

template <typename Authorization>
struct chain<Authorization>
{
    template <typename StreamPtr, typename Handler>
    void operator()(
        const settings_ptr&,
        const StreamPtr&,
        const std::vector<string>&,
        Handler&& handler)
    {
        // No method was applicable.
        handler(make_error(auth_error::no_credentials), Authorization{});
    }
};

template <typename Authorization, typename Method, typename... Methods>
struct chain<Authorization, Method, Methods...> : public chain<Authorization, Methods...>
{
    using method = std::decay_t<Method>;
    using tail = chain<Authorization, Methods...>;

    chain(Method&& head_, Methods&&... tail_)
        : tail(std::forward<Methods>(tail_)...), head(std::forward<Method>(head_))
    {
    }

    template <typename StreamPtr, typename Handler>
    void operator()(
        const settings_ptr& settings,
        const StreamPtr& stream,
        const std::vector<string>& service_names,
        Handler&& handler)
    {
        head(
            settings,
            stream,
            service_names,
            [this, settings, stream, service_names, handler_ = std::forward<Handler>(handler)](
                auto&& ec, auto&& auth) mutable {
                if (ec == make_error(auth_error::no_credentials))
                {
                    tail::operator()(settings, stream, service_names, std::move(handler_));
                }
                else
                {
                    handler_(ec, auth);
                }
            });
    }

private:
    method head;
};

}
