#pragma once

namespace yxiva::web::auth {

template <typename StreamPtr>
inline auto get_token_from_header(const StreamPtr& stream, const string& auth_prefix)
{
    auto& headers = stream->request()->headers;

    auto it = headers.find("authorization");
    if (it != headers.end() && boost::algorithm::istarts_with(it->second, auth_prefix))
    {
        auto token = it->second.substr(auth_prefix.size());
        boost::trim(token);
        return token;
    }
    return string();
}

}