#pragma once

#include "web/auth/methods/get_token.h"
#include "web/auth/authorization.h"
#include "web/auth/error.h"
#include "web/auth/oauth.h"

namespace yxiva::web::auth {

struct oauth
{
    bbclient_ptr bbclient;

    template <typename StreamPtr, typename Handler>
    void operator()(
        const settings_ptr& settings,
        const StreamPtr& stream,
        const std::vector<string>& service_names,
        Handler&& handler)
    {
        static const string OAUTH_PREFIX = "OAuth ";

        auto token = get_token_from_header(stream, OAUTH_PREFIX);
        if (token.empty())
        {
            handler(make_error(auth_error::no_credentials), user_authorization{});
            return;
        }
        auto ctx = stream->request()->context;
        ctx->profilers.push("passport::oauth");
        resolve_config_with_oauth(
            bbclient,
            settings,
            token,
            service_names,
            { ctx->remote_address, ctx->remote_port },
            [stream, handler_ = std::forward<Handler>(handler)](
                operation::result checked, auto&& auth) mutable {
                auto ctx = stream->request()->context;
                ctx->profilers.pop();
                if (!checked)
                {
                    YLOG_CTX_GLOBAL(ctx, info) << "oauth unauthorized: "
                                                  "reason=\""
                                               << checked.error_reason << "\"";
                    handler_(make_error(auth_error::authorization_error), user_authorization{});
                    return;
                }
                handler_(boost::system::error_code{}, auth);
            });
    }
};

}