#include "oauth.h"

namespace yxiva { namespace web { namespace detail {

operation::result fill_user_auth(
    user_authorization& auth,
    settings_ptr settings,
    const services_type& services,
    const ymod_blackbox::session_id_response& bb_response)
{
    ymod_blackbox::uid_option uid_option;
    ymod_blackbox::oauth_info_option oauth_info;
    ymod_blackbox::connection_id_option connection_id;

    try
    {
        bb_response >> oauth_info >> connection_id >> uid_option;
    }
    catch (const std::exception& e)
    {
        return string("check failed: ") + e.what();
    }
    catch (...)
    {
        return "check failed";
    }

    auto checked = check_scopes(oauth_info, settings->api.user_oauth_scopes);
    if (!checked) return checked;

    for (auto& service : services)
    {
        auto res = check_scopes(oauth_info, service->properties.oauth_scopes);
        if (!res)
        {
            return res;
        }
    }

    if (uid_option.uid.empty()) return "no uid in token";
    if (!oauth_info.client_is_yandex) return "not a yandex client";

    auth.uid = uid_option.uid;
    auth.bb_connection_id = connection_id.value;
    return operation::success;
}

} // detail
} // web
} // yxiva
