#pragma once

#include "error.h"
#include "web/find_deps.h"
#include "web/types.h"

#include <yxiva/core/types.h>
#include <yxiva/core/user_info.h>
#include <functional>

namespace yxiva { namespace web {

using auth_callback_t = std::function<void(const auth_error::error_code&, const auth_info&)>;

user_info_future_t auth_user(request_ptr req);

void auth_user_cookies(
    const std::shared_ptr<yhttp::cluster_client>& http_client,
    task_context_ptr ctx,
    const string& cookie,
    const string& auth_domain,
    const address& user_address,
    auth_callback_t cb);

void auth_user_cookies(
    task_context_ptr ctx,
    const string& cookie,
    const string& auth_domain,
    const address& user_address,
    auth_callback_t cb);

}}