#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace backapi {

void check_token(settings_ptr settings, const http_stream_ptr& stream)
{
    static const string ERROR_ENV = "failed to get some environments";
    static const string ERROR_NO_TOKEN = "missing or empty X-XivaToken header";
    static const string ERROR_INACCESSIBLE = "inaccessible";
    static const string TYPE_SEND = "send token";
    static const string TYPE_LISTEN = "listen token";
    static const string ENV_ANY = "any";

    auto& headers = stream->request()->headers;
    auto it = headers.find("x-xivatoken");

    if (it == headers.end() || it->second.empty())
    {
        return stream->result(ymod_webserver::codes::bad_request, ERROR_NO_TOKEN);
    }

    auto& token = it->second;
    bool found = false;
    json_value result;
    auto&& env_result = result["environments"][ENV_ANY];
    env_result.set_object();

    // Try to use webui service manager as it should have more envs available.
    if (auto service_manager = find_service_manager(
            settings->api.webui.enabled ? settings->api.webui.service_manager :
                                          settings->api.auth_service_manager))
    {
        auto service = service_manager->find_service_by_send_token(token);
        auto& token_type = service ? TYPE_SEND : TYPE_LISTEN;
        // For compatibility.
        if (!service) service = service_manager->find_service_by_listen_token(token);
        if (service)
        {
            found = true;
            env_result["type"] = token_type;
            env_result["service"] = service->properties.name;
            env_result["owner"] = service->properties.owner();
            env_result["description"] = service->properties.description;
        }
    }
    else
    {
        result["error"] = ERROR_ENV;
        env_result["error"] = ERROR_INACCESSIBLE;
    }

    result["token_found"] = found;

    stream->set_code(ymod_webserver::codes::ok);
    stream->set_content_type("application/json");
    stream->result_body(result.stringify());
}

}}}
