#pragma once

#include "common.h"

namespace yxiva { namespace web { namespace backapi {

void list_applications(settings_ptr /*settings*/, const http_stream_ptr& stream)
{
    using namespace ymod_xconf;
    find_xconf()->list(
        config_type::MOBILE,
        INITIAL_REVISION,
        [stream](const error_code& errc, conf_list_ptr confs) {
            if (errc)
            {
                YLOG_CTX_GLOBAL(stream->ctx(), error)
                    << "listing mobile app confs: error=\"" << errc.message() << "\"";
                stream->result(ymod_webserver::codes::bad_request, errc.message());
            }
            else
            {
                std::stringstream ss;
                ss << "bb_ID\tservice\tplatform\tapp_name\tttl\n";
                for (auto& conf : confs->items)
                {
                    application_config app;
                    try
                    {
                        unpack(conf.configuration, app);
                        app.platform =
                            platform::resolve_alias(app.platform).name; // gcm_compatibility
                        ss << (app.bb_client_id.size() ? app.bb_client_id : "-") << "\t"
                           << (app.xiva_service.size() ? app.xiva_service : "-") << "\t"
                           << app.platform << "\t" << app.app_name << "\t"
                           << (app.ttl ? std::to_string(app.ttl) : "-");
                        //<< app.secret_key;
                    }
                    catch (const std::exception& ex)
                    {
                        ss << "bad configuration: name=\"" << conf.name << "\" exception=\""
                           << ex.what() << "\"";
                    }
                    ss << "\n";
                }
                stream->result(ymod_webserver::codes::ok, ss.str());
            }
        },
        stream->ctx());
}
}}}
